<?php
/*
Plugin Name: Slz Core
Plugin URI: http://themeforest.net/user/swlabs
Description: Slz Core Plugin for BuildPlus Theme
Version: 2.2
Author: Swlabs
Author URI: http://themeforest.net/user/swlabs
Text Domain: slz-core
*/

clearstatcache();

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

// load constants
require_once( plugin_dir_path( __FILE__ ) . '/constants.php' );

/* Load plugin textdomain.*/
load_plugin_textdomain( 'slz-core', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );

/* Initialization */
require_once( BUILDPLUS_CORE_FRAMEWORK_DIR . '/class-slz-loader.php' );
require_once( BUILDPLUS_CORE_FRAMEWORK_DIR . '/class-slz-config.php' );
require_once( BUILDPLUS_CORE_FRAMEWORK_DIR . '/class-slz-params.php' );
require_once( plugin_dir_path( __FILE__ ) . '/class-slz.php' );
require_once( BUILDPLUS_CORE_FRAMEWORK_DIR . '/class-slz-format.php' );
require_once( BUILDPLUS_CORE_FRAMEWORK_DIR . '/class-slz-util.php' );
require_once( BUILDPLUS_CORE_FRAMEWORK_DIR . '/class-slz-com.php' );

require_once( plugin_dir_path( __FILE__ ) . '/custom-functions.php' );
require_once( plugin_dir_path( __FILE__ ) . '/framework/modules/importer/index.php' );

Buildplus_Core::load_class( 'Abstract' );
Buildplus_Core::load_class( 'Helper' );
Buildplus_Core::load_class( 'Social_Share' );
Buildplus_Core::load_class( 'models.Custom_Post_Model' );
Buildplus_Core::load_class( 'models.Taxonomy_Model' );
Buildplus_Core::load_class( 'models.Video_Model' );
Buildplus_Core::load_class( 'models.Pagination' );

Buildplus_Core::load_class( 'shortcode.Blog' );
Buildplus_Core::load_class( 'shortcode.Button' );
Buildplus_Core::load_class( 'shortcode.Gallery' );
Buildplus_Core::load_class( 'shortcode.Icon_Box' );
Buildplus_Core::load_class( 'shortcode.Image_Box' );
Buildplus_Core::load_class( 'shortcode.Partner' );
Buildplus_Core::load_class( 'shortcode.Project' );
Buildplus_Core::load_class( 'shortcode.Service' );
Buildplus_Core::load_class( 'shortcode.Team' );
Buildplus_Core::load_class( 'shortcode.Testimonial' );
Buildplus_Core::load_class( 'shortcode.Toggle' );
Buildplus_Core::load_class( 'shortcode.Contact' );
Buildplus_Core::load_class( 'shortcode.Number_Factor' );
Buildplus_Core::load_class( 'shortcode.Block_Title' );
Buildplus_Core::load_class( 'shortcode.Banner' );
Buildplus_Core::load_class( 'shortcode.Contact_map' );
Buildplus_Core::load_class( 'shortcode.Item_List' );
Buildplus_Core::load_class( 'shortcode.Pricing_Table' );
$app = Buildplus_Core::new_object('Application');
$app->run();
if(BUILDPLUS_CORE_IMPORT_TAXONOMY_ACTIVE) {
	$opt = Buildplus_Core::new_object('Options_Importer');
	$opt->instance();
}

Buildplus_Core::load_class( 'setting.Taxonomies_Controller' );
if( BUILDPLUS_CORE_VC_ACTIVE ) {
	add_action('vc_before_init', array( 'Buildplus_Core', '[shortcode.Shortcodes_Controller, vc_map_shortcodes]' ) );
}
add_action('init', array( 'Buildplus_Core', '[shortcode.Shortcodes_Controller, init]' ) );

if( ! is_admin() ) {
	add_action( 'wp_enqueue_scripts', array( 'Buildplus_Core', '[setting.Setting_Init, dev_enqueue_scripts]' ) );
}