<?php
/**
 * Top Controller.
 * 
 * @since 1.0
 */
Buildplus::load_class( 'Abstract' );

class Buildplus_Top_Controller extends Buildplus_Abstract {
	public function show_post_index(){
		$this->render( BUILDPLUS_THEME_DIR . '/index.php', array() );
	}
	public function show_project_archive(){
		$this->render( BUILDPLUS_THEME_DIR . '/inc/template-project-list.php', array() );
	}
	public function show_service_archive(){
		$this->render( BUILDPLUS_THEME_DIR . '/inc/template-service-list.php', array() );
	}
	public function show_team_archive(){
		$this->render( BUILDPLUS_THEME_DIR . '/inc/template-team-list.php', array() );
	}
	public function header() {
		$this->render( 'header', array());
	}
	public function show_subcribe() {
		$this->render( 'subcribe');
	}
	public function footer_main() {
		$this->render( 'footer', array());
	}
	public function footer_contact() {
		$this->render( 'footer-contact', array());
	}
	public function breadcrumb() {
		$this->render( 'breadcrumb', array());
	}
	public function show_post_entry_thumbnail( $args = array() ) {
		$this->render( 'entry-thumbnail', array ( 'args' => $args ) );
	}
	public function show_post_entry_meta( $args = array() ) {
		$posttags = get_the_tags();
		$category_list = get_the_category();
		$this->render( 'entry-meta', array (
			'args' => $args,
			'posttags' => $posttags,
			'category_list' => $category_list 
		) );
	}
	public function show_post_tags_meta( $args = array() ) {
		$posttags = get_the_tags();
		$this->render( 'tags-meta', array (
			'args' => $args,
			'posttags' => $posttags
		) );
	}
	public function show_post_category_meta( $args = array() ) {
		$postcats = get_the_category();
		$this->render( 'categories-meta', array (
			'args' => $args,
			'postcats' => $postcats
		) );
	}
	public function show_post_author() {
		$this->render( 'author', array () );
	}
	public function show_author_list() {
		$this->render( 'author_list');
	}
	public function loading_page() {
		$this->render( 'loading_page');
	}
	public function show_post_entry_video( $args = array() ) {
		if(class_exists('Buildplus_Core_Video_Model')){
			$post_id = get_the_ID();
			$post_options = get_post_meta( $post_id, 'buildplus_feature_video', true);
			$youtube_id = Buildplus::get_value( $post_options, 'youtube_id' );
			$vimeo_id = Buildplus::get_value( $post_options, 'vimeo_id' );
			$upload_video = Buildplus::get_value( $post_options, 'upload_video' );
			if(empty($youtube_id) && empty($vimeo_id) && empty($upload_video) ){
				do_action( 'buildplus_entry_thumbnail');
			}
			else{
				$video_model = new Buildplus_Core_Video_Model();
				$video_model->init();
				echo ( $video_model->get_video( $post_options['video_type'] , $youtube_id, $vimeo_id , $upload_video ) );
			}
		} else {
			do_action( 'buildplus_entry_thumbnail');
		}
	}
	public function show_page_title() {
		$this->render( 'page-title',array() );
	}
	public function show_slider() {
		$this->render( 'slider',array() );
	}
	// share post
	public function get_share_link() {
		$this->render( 'share_link', array());
	}
	public function show_login_link( $arg = array() ) {
		$this->render( 'login-link');
	}
	// show comments
	public function show_frm_comment() {
		$this->render( 'comment_frm');
	}
	public function show_help_link() {
		$this->render( 'help_link');
	}
	public function show_post_nav() {
		$this->render( 'post_navigation');
	}
	public function show_hamburger_menu() {
		$this->render( 'hamburger-menu');
	}
}