<?php
/**
 * Widget_Init class.
 * 
 * @since 1.0
 */
Buildplus::load_class( 'widget.Widget_Recent_Post' );
Buildplus::load_class( 'widget.Widget_About_Us' );
Buildplus::load_class( 'widget.Widget_Contact' );

if(BUILDPLUS_CORE_IS_ACTIVE) {
	Buildplus::load_class( 'widget.Widget_Taxonomy' );
	Buildplus::load_class( 'widget.Widget_Service' );
	Buildplus::load_class( 'widget.Widget_Project' );
	Buildplus::load_class( 'widget.Widget_Advertisement' );
	Buildplus::load_class( 'widget.Widget_Project_Attributes' );
	Buildplus::load_class( 'widget.Widget_Files_List' );
	Buildplus::load_class( 'widget.Widget_Gallery' );
}
class Buildplus_Widget_Init {
	/**
	 * Load widgets
	 *
	 */
	public function load() {
		register_widget( 'Buildplus_Widget_Recent_Post' );
		register_widget( 'Buildplus_Widget_About_Us' );
		register_widget( 'Buildplus_Widget_Contact' );
		if(BUILDPLUS_CORE_IS_ACTIVE) {
			register_widget( 'Buildplus_Widget_Taxonomy' );
			register_widget( 'Buildplus_Widget_Service' );
			register_widget( 'Buildplus_Widget_Project' );
			register_widget( 'Buildplus_Widget_Advertisement' );
			register_widget( 'Buildplus_Widget_Project_Attributes' );
			register_widget( 'Buildplus_Widget_Files_List' );
			register_widget( 'Buildplus_Widget_Gallery' );
		}
	}
	/**
	 * Register sidebars
	 *
	 */
	public function widgets_init() {
		register_sidebar( array (
			'name'          => esc_html__( 'Default Widget Area', 'buildplus' ),
			'id'            => 'buildplus-sidebar-default',
			'description'   => esc_html__( 'Add widgets here to appear in sidebar of posts and pages', 'buildplus'),
			'before_widget' => '<div id="%1$s" class="widget-sidebar slz-widget  box %2$s widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title-widget">',
			'after_title'   => '</div>'
		));
		// Register footer area
		for ( $i = 1; $i < 5; $i++ ) {
			register_sidebar( array (
				'name'          => sprintf( esc_html__( 'Footer Widget Area %s', 'buildplus' ), $i ),
				'id'            => 'buildplus-sidebar-footer-' . $i,
				'description'   => sprintf( esc_html__( 'Add widgets here to appear in footer column %s.', 'buildplus' ), $i ),
				'before_widget' => '<div id="%1$s" class="%2$s slz-widget widget widget-footer">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="title-widget">',
				'after_title'   => '</div>'
			));
		}
		//Register sidebar main
		register_sidebar( array (
			'name'          => esc_html__( 'Main Widget Area', 'buildplus' ),
			'id'            => 'buildplus-sidebar-main',
			'description'   => esc_html__( 'Add widgets here to appear in sidebar pages.', 'buildplus' ),
			'before_widget' => '<div id="%1$s" class="widget-sidebar slz-widget  box %2$s widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title-widget">',
			'after_title'   => '</div>'
		));
		//Register sidebar mblog
		register_sidebar( array (
			'name'          => esc_html__( 'Blog Widget Area', 'buildplus' ),
			'id'            => 'buildplus-sidebar-blog',
			'description'   => esc_html__( 'Add widgets here to appear in sidebar of posts.', 'buildplus' ),
			'before_widget' => '<div id="%1$s" class="widget-sidebar slz-widget box %2$s widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title-widget">',
			'after_title'   => '</div>'
		));
		//Register sidebar main
		register_sidebar( array (
			'name'          => esc_html__( 'Footer Top Widget Area', 'buildplus' ),
			'id'            => 'buildplus-footer-top',
			'description'   => esc_html__( 'Add widgets here to appear in footer top.', 'buildplus' ),
			'before_widget' => '<div id="%1$s" class="widget-sidebar slz-widget  box %2$s widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title-widget">',
			'after_title'   => '</div>'
		));
		// Register custom sidebar
		$sidebars = get_option('buildplus_custom_sidebar');
		$args =  array (
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '',
			'after_title'   => ''
		);
		if( is_array( $sidebars ) ) {
			foreach ( $sidebars as $sidebar ) {
				if( !empty($sidebar) ) {
					$name = isset($sidebar['name']) ? $sidebar['name'] : '';
					$title = isset($sidebar['title']) ? $sidebar['title'] : '';
					$class = isset($sidebar['class']) ? $sidebar['class'] : '';
					$args['name']   = $title;
					$args['id']     = str_replace(' ','-',strtolower( $name ));
					$args['class']  = 'slz-custom';
					$args['before_widget'] = '<div class="widget-sidebar slz-widget box %2$s widget '. $class .'">';
					$args['after_widget']  = '</div>';
					$args['before_title']  = '<div class="title-widget">';
					$args['after_title']   = '</div>';
					register_sidebar($args);
				}
			}
		}
	}
	/**
	 * Add custom sidebar area
	 *
	 */
	public function add_widget_field() {
		$nonce =  wp_create_nonce ('buildplus-delete-sidebar-nonce');
		$nonce = '<input type="hidden" name="buildplus-delete-sidebar-nonce" value="'.esc_attr($nonce).'" />';
		echo "\n<script type='text/html' id='buildplus-custom-widget'>";
		echo "\n  <form class='buildplus-add-widget' method='POST'>";
		echo "\n  <h3>".esc_html__('BuildPlus Custom Widgets', 'buildplus')."</h3>";
		echo "\n    <input class='buildplus_style_wrap' type='text' value='' placeholder = '". esc_html__('Enter Name of the new Widget Area here', 'buildplus') ."' name='buildplus-add-widget[name]' />";
		echo "\n    <input class='buildplus_style_wrap' type='text' value='' placeholder = '". esc_html__('Enter class display on front-end', 'buildplus') ."' name='buildplus-add-widget[class]' />";
		echo "\n    <input class='buildplus_button' type='submit' value='". esc_html__('Add Widget Area', 'buildplus') ."' />";
		echo "\n    ".$nonce;
		echo "\n  </form>";
		echo "\n</script>\n";
	}

	public function add_sidebar_area() {
		if( isset($_POST['buildplus-add-widget']) && !empty($_POST['buildplus-add-widget']['name']) ) {
			$sidebars = array();
			$sidebars = get_option('buildplus_custom_sidebar');
			$name = $this->get_name($_POST['buildplus-add-widget']['name']);
			$class = $_POST['buildplus-add-widget']['class'];
			$sidebars[] = array('name'=>sanitize_title($name), 'title' => $name, 'class'=>$class);
			update_option('buildplus_custom_sidebar', $sidebars);
			wp_redirect( esc_url( admin_url('widgets.php') ) );
			die();
		}
	}

	public function get_name( $name ) {
		if( empty($GLOBALS['wp_registered_sidebars']) ){
			return $name;
		}

		$taken = array();
		foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
			$taken[] = $sidebar['name'];
		}
		$sidebars = get_option('buildplus_custom_sidebar');

		if( empty($sidebars) ) {
			$sidebars = array();
		}

		$taken = array_merge($taken, $sidebars);
		if( in_array($name, $taken) ) {
			$counter  = substr($name, -1);
			$new_name = "";
			if( !is_numeric($counter) ) {
				$new_name = $name . " 1";
			}
			else {
				$new_name = substr($name, 0, -1) . ((int) $counter + 1);
			}
			$name = $new_name;
		}
		return $name;
	}
	public function delete_custom_sidebar() {
		check_ajax_referer('buildplus-delete-sidebar-nonce');
		if( !empty($_POST['name']) ) {
			$name = sanitize_title($_POST['name']);
			$sidebars = get_option('buildplus_custom_sidebar');
			foreach($sidebars as $key => $sidebar){
				if( strcmp(trim($sidebar['name']), trim($name)) == 0) {
					unset($sidebars[$key]);
					update_option('buildplus_custom_sidebar', $sidebars);
					echo "success";
					break;
				}
			}
		}
		die();
	}
}