<?php 
/**
 * Widget_Taxonomy class.
 *
 * @since 1.0
 */

class Buildplus_Widget_Taxonomy extends WP_Widget{
	
	public function __construct(){
		$widget_ops = array('classname' => 'widget_slz_taxonomy', 'description' => esc_html__('A list of taxonomy','buildplus'));
		parent::__construct('buildplus_taxonomy', esc_html_x('SLZ: Taxonomy', 'Taxonomy widget','buildplus' ),$widget_ops);
	}
	
	function form($instance){
		$default = array(
			'title'      => esc_html__("Categories", 'buildplus'),
			'limit_list' => '5',
			'taxonomy'   => '',
			'show_count' => 'on',
		);
		$check_box = array(
			'show_count'       => esc_html__( 'Show post counts?', 'buildplus' ),
		);
		$instance   = wp_parse_args((array) $instance, $default);
		$title      = $instance['title'];
		$limit_list = $instance['limit_list'];
		$taxonomy   = $instance['taxonomy'];
		$show_count = $instance['show_count'];
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title') );?>"><?php esc_html_e('Title: ', 'buildplus' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('title') ); ?>" name="<?php echo esc_attr($this->get_field_name('title') ); ?>" value="<?php echo esc_attr($title); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('limit_list') );?>"><?php esc_html_e('Enter limit of list category: ', 'buildplus' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('limit_list') ); ?>" name="<?php echo esc_attr($this->get_field_name('limit_list') ); ?>" value="<?php echo esc_attr($limit_list); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('taxonomy') ); ?>"><?php esc_html_e( 'Choose Taxonomy', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('taxonomy') ); ?>" name="<?php echo esc_attr( $this->get_field_name('taxonomy') ); ?>" >
			<?php
				$arr_tax = array(
					''                           => esc_html__( 'Category', 'buildplus' ),
					'buildplus_project_cat'      => esc_html__( 'Project Category', 'buildplus' ),
					'buildplus_project_location' => esc_html__( 'Project Locations', 'buildplus' ),
					'buildplus_service_cat'      => esc_html__( 'Service Category', 'buildplus' ),
					'buildplus_team_cat'         => esc_html__( 'Team Category', 'buildplus' ),
				);
				foreach( $arr_tax as $key=>$value ){
					$selected = '';
					if( $taxonomy == $key ){
						$selected = 'selected';
					}
					printf('<option value="%1$s" %2$s>%3$s</option>', $key, $selected, $value);
				}
			?>
			</select>
		</p>
		<?php
			$format = '
				<p>
					<input class="checkbox" type="checkbox" %1$s id="%2$s" name="%3$s" />
					<label for="%4$s">%5$s</label>
				</p>';
			foreach( $check_box as $field => $text ) {
				printf( $format,
						checked($instance[$field], 'on', false ),
						esc_attr( $this->get_field_id($field) ),
						esc_attr( $this->get_field_name($field) ),
						esc_attr( $this->get_field_id($field) ),
						$text
					);
			}?>
	<?php
	}
	function update($new_instance,$old_instance){
		$instance = $old_instance;
		$instance['title']      = strip_tags($new_instance['title']);
		$instance['limit_list'] = strip_tags($new_instance['limit_list']);
		$instance['taxonomy']   = strip_tags($new_instance['taxonomy']);
		$instance['show_count'] = strip_tags($new_instance['show_count']);
		return $instance;
	}
	function widget($args,$instance){
		extract($args);
		$default = array(
			'title'      => '',
			'limit_list' => '',
			'taxonomy'   => '',
			'show_count' => ''
		);
		$instance = wp_parse_args((array) $instance, $default);
		$title    = apply_filters('widget_title',$instance['title'] );
		$limit_list   = $instance['limit_list'];
		$taxonomy     = $instance['taxonomy'];
		$show_count   = $instance['show_count'];
		if( empty($taxonomy) ) {
			$taxonomy = 'category';
		}
		$query_args = array();
		if( !empty($limit_list)) {
			$query_args['number'] = $limit_list;
		}
		$categories = get_terms($taxonomy, $query_args);
		echo wp_kses_post( $before_widget );?>
			<div class="widget categories-widget">
			<?php
				if( !empty( $title ) ) {
					echo wp_kses_post( $before_title );
					echo esc_html( $title );
					echo wp_kses_post( $after_title );
				}
				if( $categories && ! is_wp_error($categories)){
			?>
				<div class="categories-inner">
					<?php 
						foreach($categories as $key => $value){
							$category_id = $value->term_id;
							$category_link = get_term_link( $category_id );
							$str_count = '';
							if( $show_count ) {
								$str_count = '<span>'.esc_html('('.$value->count.')').'</span>';
							}
							echo '<a href="'.esc_url( $category_link ).'" class="link"><span class="category-count">'.esc_attr( $value->name ).'</span>'.$str_count.'<i class="icons fa fa-angle-right"></i></a>';
						}
					?>
				</div><?php
				}?>
			</div><?php 
		echo wp_kses_post( $after_widget );
	}
}