<?php
$style = array(
	esc_html__('Style 01', 'slz-core') => '2',
	esc_html__('Style 02', 'slz-core') => '3'
);
$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Style', 'slz-core' ),
		'param_name'  	=> 'style',
		'value'       	=> $style,
		'description' 	=> esc_html__( 'Choose a style for block.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Subtitle', 'slz-core' ),
		'param_name'      => 'subtitle',
		'value'           => '',
		'description'     => esc_html__( 'Enter subtitle.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'holder'          => 'div',
		'heading'         => esc_html__( 'Title', 'slz-core' ),
		'param_name'      => 'title',
		'value'           => '',
		'description'     => esc_html__( 'Enter title.', 'slz-core' )
	),
	array(
		'type'            => 'textarea_html',
		'heading'         => esc_html__( 'Description', 'slz-core' ),
		'param_name'      => 'content',
		'value'           => '',
		'description'     => esc_html__( 'Enter description.', 'slz-core' ),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')
		)
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Big Title', 'slz-core' ),
		'param_name'      => 'big_title',
		'value'           => '',
		'description'     => esc_html__( 'Enter big title.', 'slz-core' ),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('3')
		)
	),
	array(
		'type'           => 'attach_image',
		'heading'        => esc_html__( 'Big Title Background Image', 'slz-core' ),
		'param_name'     => 'bg_image',
		'value'           => '',
		'description'    => esc_html__( 'Choose background image for big title.', 'slz-core' ),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('3')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Subtitle Color', 'slz-core' ),
		'param_name'      => 'subtitle_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for subtitle.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'title_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for title.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'des_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for description.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Big Title Color', 'slz-core' ),
		'param_name'      => 'big_title_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for big title.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('3')
		)
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'value'           => '',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	)
);

vc_map(
	array(
		"name"			=> esc_html__( 'SLZ Banner', 'slz-core' ),
		"base"			=> "slzcore_banner_sc",
		"class"			=> "slzcore-sc",
		"category"		=> BUILDPLUS_CORE_SC_CATEGORY,
		'icon'			=> 'icon-slzcore_banner_sc',
		"description"	=> esc_html__( 'Create banner.', 'slz-core' ),
		"params"		=> $params
	)
);
