<?php
$style = array(
	esc_html__( 'Style 1', 'slz-core' )				=> '1',
	esc_html__( 'Style 2', 'slz-core' )				=> '2',
	esc_html__( 'Style 3', 'slz-core' )				=> '3',
	esc_html__( 'Style 4 (Grid)', 'slz-core' )		=> '4',
	esc_html__( 'Style 5 (Slider)', 'slz-core' )    => '5',
);
$column = array(
	esc_html__( 'One', 'slz-core' )				=> '1',
	esc_html__( 'Two', 'slz-core' )				=> '2',
	esc_html__( 'Three', 'slz-core' )			=> '3',
	esc_html__( 'Four', 'slz-core' )			=> '4',
);
$align = array(
	esc_html__( 'Default', 'slz-core' )			=> '4',
	esc_html__( 'Left', 'slz-core' )			=> 'left',
	esc_html__( 'Right', 'slz-core' )			=> 'right',
	esc_html__( 'Center', 'slz-core' )			=> 'center',
);
$yesno = array(
	esc_html__( 'Yes', 'slz-core' )				=> 'yes',
	esc_html__( 'No', 'slz-core' )				=> 'no',
);
$posttype = array(
	esc_html__( 'Gallery', 'slz-core' )			=> 'gallery',
	esc_html__( 'Project', 'slz-core' )			=> 'project',
);
$featured =array(
	esc_html__( 'None', 'slz-core' )			=> '',
	esc_html__( 'Featured', 'slz-core' )		=> 'feature'
);
$sort_by = Buildplus_Core_Params::get('sort-other');
$taxonomy = 'buildplus_gallery_cat';
$params_cat = array('empty'   => esc_html__( '-All Gallery Categories-', 'slz-core' ) );
$categories = Buildplus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$taxonomy_project = 'buildplus_project_cat';
$params_cat_project = array('empty'   => esc_html__( '-All Gallery Categories-', 'slz-core' ) );
$categories_project = Buildplus_Core_Com::get_tax_options2slug( $taxonomy_project, $params_cat_project );

$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Style', 'slz-core' ),
		'admin_label'	=> true,
		'param_name'  	=> 'style',
		'value'       	=> $style,
		'std'      		=> '1',
		'description' 	=> esc_html__( 'Choose style will be displayed.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Column', 'slz-core' ),
		'param_name'  	=> 'column',
		'value'       	=> $column,
		'std'      		=> '3',
		'description' 	=> esc_html__( 'Choose number column will be displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array( '4' ),
		),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Padding Item ?', 'slz-core' ),
		'param_name'  	=> 'item_padding',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to padding item.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Filter ?', 'slz-core' ),
		'param_name'  	=> 'show_filter',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show filter.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Filter All ?', 'slz-core' ),
		'param_name'  	=> 'show_filter_all',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show filter all.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Filter Title All', 'slz-core' ),
		'param_name'     => 'filter_title_all',
		'description'    => esc_html__( 'Enter text of link all posts.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter_all',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Filter Align ?', 'slz-core' ),
		'param_name'  	=> 'filter_align',
		'value'       	=> $align,
		'description' 	=> esc_html__( 'Choose YES to insert container in filter.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Container In Filter ?', 'slz-core' ),
		'param_name'  	=> 'filter_is_container',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to insert container in filter.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter',
			'value'    => array( 'yes' ),
		),
	),

	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Load More ?', 'slz-core' ),
		'param_name'  	=> 'show_loadmore',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to show button load more.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter_all',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Button Title', 'slz-core' ),
		'param_name'     => 'button_title',
		'description'    => esc_html__( 'Enter text of button load more.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
	),
	
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Container In Gallery ?', 'slz-core' ),
		'param_name'  	=> 'content_is_container',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to insert container in gallery content.', 'slz-core' ),
	),

	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '-1',
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array( '1','2','3','4' ),
		),
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'     => 'extra_class',
		'description'    => esc_html__( 'Enter extra class name.', 'slz-core' ),
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Posttype', 'slz-core' ),
		'admin_label'	  => true,
		'param_name'      => 'posttype',
		'value'           => $posttype,
		'description'     => esc_html__( 'Choose post type.', 'slz-core' ),
		'group'       	  => 'Filter'
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Featured Project', 'slz-core' ),
		'admin_label'	  => true,
		'param_name'      => 'featured_filter',
		'value'           => $featured,
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'description'     => esc_html__( 'Select filter by featured project or none.', 'slz-core' ),
		'group'       	  => 'Filter'
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Gallery Category', 'slz-core' ),
		'param_name' => 'category_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by category.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'gallery' ),
		),
		'group'       => 'Filter'
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Project Category', 'slz-core' ),
		'param_name' => 'category_list_project',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories_project,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by category.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'group'       => 'Filter'
	),

	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Filter Title Color', 'slz-core' ),
		'param_name'      => 'color_filter_title',
		'description'     => esc_html__( 'Choose color for navigation title.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Filter Title Color Active', 'slz-core' ),
		'param_name'      => 'color_filter_title_at',
		'description'     => esc_html__( 'Choose color for navigation title when active.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Filter Title Line Color', 'slz-core' ),
		'param_name'      => 'color_filter_line',
		'description'     => esc_html__( 'Choose color for navigation title line.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_filter',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Title Color', 'slz-core' ),
		'param_name'      => 'color_button_title',
		'description'     => esc_html__( 'Choose color for button title.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Title Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_title_hv',
		'description'     => esc_html__( 'Choose color for button title when hover.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color', 'slz-core' ),
		'param_name'      => 'color_button_bg',
		'description'     => esc_html__( 'Choose color for button title.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_bg_hv',
		'description'     => esc_html__( 'Choose color for button title when hover.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Border Color', 'slz-core' ),
		'param_name'      => 'color_button_border',
		'description'     => esc_html__( 'Choose color for button border.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Border Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_border_hv',
		'description'     => esc_html__( 'Choose color for button border when hover.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_loadmore',
			'value'    => array( 'yes' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Background Item', 'slz-core' ),
		'param_name'      => 'color_item_bg',
		'description'     => esc_html__( 'Choose color for item background when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Border Item', 'slz-core' ),
		'param_name'      => 'color_item_border',
		'description'     => esc_html__( 'Choose color for bottom border item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Item', 'slz-core' ),
		'param_name'      => 'color_item_button',
		'description'     => esc_html__( 'Choose color for button item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Background Button Item ', 'slz-core' ),
		'param_name'      => 'color_item_button_bg',
		'description'     => esc_html__( 'Choose color for background button item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Tittle Item ', 'slz-core' ),
		'param_name'      => 'color_item_title',
		'description'     => esc_html__( 'Choose color for title item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Tittle Item Hover', 'slz-core' ),
		'param_name'      => 'color_item_title_hv',
		'description'     => esc_html__( 'Choose color for title item when hover title.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Line Tittle Item', 'slz-core' ),
		'param_name'      => 'color_item_title_line',
		'description'     => esc_html__( 'Choose color for line title item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Category Item', 'slz-core' ),
		'param_name'      => 'color_item_cat',
		'description'     => esc_html__( 'Choose color for category item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Category Item Hover', 'slz-core' ),
		'param_name'      => 'color_item_cat_hv',
		'description'     => esc_html__( 'Choose color for category item when hover category.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Arrows Color', 'slz-core' ),
		'param_name'      => 'arrows_color',
		'description'     => esc_html__( 'Choose color for arrow of slider.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array( '5' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Arrows Background Color', 'slz-core' ),
		'param_name'      => 'arrows_bg_color',
		'description'     => esc_html__( 'Choose background color for arrow of slider.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array( '5' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Gallery Masonry', 'slz-core' ),
	'base'        => 'slzcore_gallery_masonry_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_gallery_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Photos of gallery masonry, grid.', 'slz-core' ),
	'params'      => $params
));