<?php
$column = array(
	esc_html__( 'One', 'slz-core' )				=> '1',
	esc_html__( 'Two', 'slz-core' )				=> '2',
	esc_html__( 'Three', 'slz-core' )			=> '3',
	esc_html__( 'Four', 'slz-core' )			=> '4',
);
$yesno = array(
	esc_html__( 'Yes', 'slz-core' )				=> 'yes',
	esc_html__( 'No', 'slz-core' )				=> 'no',
);
$posttype = array(
	esc_html__( 'Gallery', 'slz-core' )			=> 'gallery',
	esc_html__( 'Project', 'slz-core' )			=> 'project',
);
$sort_by = Buildplus_Core_Params::get('sort-gallery');
$taxonomy = 'buildplus_gallery_cat';
$params_cat = array('empty'   => esc_html__( '-All Gallery Categories-', 'slz-core' ) );
$categories = Buildplus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$taxonomy_project = 'buildplus_project_cat';
$params_cat_project = array('empty'   => esc_html__( '-All Gallery Categories-', 'slz-core' ) );
$categories_project = Buildplus_Core_Com::get_tax_options2slug( $taxonomy_project, $params_cat_project );

$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Column', 'slz-core' ),
		'param_name'  	=> 'column',
		'value'       	=> $column,
		'std'      		=> '3',
		'description' 	=> esc_html__( 'Choose number column will be displayed.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Padding Item ?', 'slz-core' ),
		'param_name'  	=> 'item_padding',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to padding item.', 'slz-core' )
	),

	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '-1',
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'     => 'extra_class',
		'description'    => esc_html__( 'Enter extra class name.', 'slz-core' ),
	),

	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Posttype', 'slz-core' ),
		'admin_label'	  => true,
		'param_name'      => 'posttype',
		'value'           => $posttype,
		'description'     => esc_html__( 'Choose post type.', 'slz-core' ),
		'group'       	  => 'Filter'
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Gallery Category', 'slz-core' ),
		'param_name' => 'category_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'callbacks'   => array(
			'after_add' => 'vcChartParamAfterAddCallback'
		),
		'description' => esc_html__( 'Default no filter by category.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'gallery' ),
		),
		'group'       => 'Filter'
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Project Category', 'slz-core' ),
		'param_name' => 'category_list_project',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories_project,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by category.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'group'       => 'Filter'
	),

	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Auto Play ?', 'slz-core' ),
		'param_name'  	=> 'slide_autoplay',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to slide auto play.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Dots Navigation ?', 'slz-core' ),
		'param_name'  	=> 'slide_dots',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show dot navigation.', 'slz-core' ),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Arrows Navigation ?', 'slz-core' ),
		'param_name'  	=> 'slide_arrows',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to show arrow navigation.', 'slz-core' ),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Loop Infinite ?', 'slz-core' ),
		'param_name'  	=> 'slide_infinite',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to slide loop infinite.', 'slz-core' ),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Speed Slide', 'slz-core' ),
		'param_name'     => 'slide_speed',
		'value'			 => '600',
		'description'    => esc_html__( 'Enter number value. Unit is millisecond. Example: 600.', 'slz-core' ),
		'group'          => esc_html__('Slide Custom', 'slz-core'),
	),

	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Background Item', 'slz-core' ),
		'param_name'      => 'color_item_bg',
		'description'     => esc_html__( 'Choose color for item background when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Border Item', 'slz-core' ),
		'param_name'      => 'color_item_border',
		'description'     => esc_html__( 'Choose color for bottom border item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Item', 'slz-core' ),
		'param_name'      => 'color_item_button',
		'description'     => esc_html__( 'Choose color for button item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Background Button Item ', 'slz-core' ),
		'param_name'      => 'color_item_button_bg',
		'description'     => esc_html__( 'Choose color for background button item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Tittle Item ', 'slz-core' ),
		'param_name'      => 'color_item_title',
		'description'     => esc_html__( 'Choose color for title item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Tittle Item Hover', 'slz-core' ),
		'param_name'      => 'color_item_title_hv',
		'description'     => esc_html__( 'Choose color for title item when hover title.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Line Tittle Item ', 'slz-core' ),
		'param_name'      => 'color_item_title_line',
		'description'     => esc_html__( 'Choose color for line title item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Category Item ', 'slz-core' ),
		'param_name'      => 'color_item_cat',
		'description'     => esc_html__( 'Choose color for category item when hover block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Category Item Hover', 'slz-core' ),
		'param_name'      => 'color_item_cat_hv',
		'description'     => esc_html__( 'Choose color for category item when hover category.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'posttype',
			'value'    => array( 'project' ),
		),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Gallery Slide', 'slz-core' ),
	'base'        => 'slzcore_gallery_slide_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_gallery_slide_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Photos of gallery slide.', 'slz-core' ),
	'params'      => $params
));