<?php
$category = Buildplus_Core_Com::get_category2slug_array();
$tag      = Buildplus_Core_Com::get_tax_options2slug( 'post_tag', array('empty' => esc_html__( '-All tags-', 'slz-core' ) ) );
$author   = Buildplus_Core_Com::get_user_login2id(array(), array('empty' => esc_html__( '-All authors-', 'slz-core' ) ) );
$orderby  = Buildplus_Core_Params::get('sort-blog');
$formats  = Buildplus_Core_Com::get_post_formats( array(esc_html__( '-All formats-', 'slz-core' ) => '' ) );
$date_style   = array(
	esc_html__('Normal Style', 'slz-core')=> '',
	esc_html__('Ribbon Style', 'slz-core')=> 'ribbon',
	esc_html__('Hide', 'slz-core') => 'no',
);
$params = array(
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'  => 'limit_post',
		'value'       => 5,
		'description' => esc_html__( 'Enter limit of posts per page. If it blank the limit posts will be the number from Wordpress settings -> Reading. If you want show all, enter "-1".', 'slz-core' )
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'  => 'offset_post',
		'value'       => '',
		'description' => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5.', 'slz-core' )
	),
	
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'  => 'sort_by',
		'value'       => $orderby,
		'description' => esc_html__( 'Choose criteria to display.', 'slz-core' )
	),
	
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'  => 'extra_class',
		'description' => esc_html__( 'Enter extra class.', 'slz-core' )
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Category', 'slz-core' ),
		'param_name' => 'category_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $category,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by category.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Tag', 'slz-core' ),
		'param_name' => 'tag_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Tag', 'slz-core' ),
				'param_name'  => 'tag_slug',
				'value'       => $tag,
				'description' => esc_html__( 'Choose special tag to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by tag.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Author', 'slz-core' ),
		'param_name' => 'author_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Author', 'slz-core' ),
				'param_name'  => 'author',
				'value'       => $author,
				'description' => esc_html__( 'Choose special author to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by author.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Post Formats', 'slz-core' ),
		'param_name' => 'format_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Author', 'slz-core' ),
				'param_name'  => 'post_format',
				'value'       => $formats,
				'description' => esc_html__( 'Choose special post format to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by post format.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Date Style', 'slz-core' ),
		'param_name'  => 'show_date',
		'value'       => $date_style,
		'description' => esc_html__( 'Choose style to display or hide post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Excerpt Length', 'slz-core' ),
		'param_name'  => 'excerpt_length',
		'value'       => '',
		'description' => esc_html__( 'Enter limit of text will be truncated. If it is empty, the default is not cut. It will trim word', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'checkbox',
		'heading'     => esc_html__( 'Hide Prev/Next Arrows', 'slz-core' ),
		'param_name'  => 'no_arrows',
		'value'       => array( esc_html__( 'Yes', 'slz-core' ) => 'yes' ),
		'description' => esc_html__( 'Check it to hide Prev/Next arrows.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Ribbon Date Background Color', 'slz-core' ),
		'param_name'  => 'date_bg_color',
		'value'       => '',
		'dependency' => array(
			'element' => 'show_date',
			'value'   => array( 'ribbon' ),
		),
		'description' => esc_html__( 'Enter backgroundcolor for post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Date Color', 'slz-core' ),
		'param_name'  => 'date_color',
		'value'       => '',
		'description' => esc_html__( 'Enter color for post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Hover Color', 'slz-core' ),
		'param_name'  => 'hover_color',
		'value'       => '',
		'description' => esc_html__( 'Enter hover color for title, more icon.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
);
vc_map(array(
	'name'               => esc_html__( 'SLZ Post Carousel', 'slz-core' ),
	'base'               => 'slzcore_post_carousel_sc',
	'class'              => 'slzcore-sc',
	'icon'               => 'icon-slzcore_post_carousel_sc',
	'category'           => BUILDPLUS_CORE_SC_CATEGORY,
	'description'        => esc_html__( 'List posts by carousel.', 'slz-core' ),
	'params'             => $params
));