<?php
$yes_no  = array(
	esc_html__('Yes', 'slz-core')			=> 'yes',
	esc_html__('No', 'slz-core')			=> 'no',
);
$desc_type  = array(
	esc_html__('Short Description', 'slz-core')		=> 'desc_short',
	esc_html__('Project Description', 'slz-core')	=> 'desc_proj',
);
$method = array(
	esc_html__( 'Category', 'slz-core' )	=> 'cat',
	esc_html__( 'Project', 'slz-core' ) 	=> 'project'
);
$sort_by = array(
	esc_html__( '- Latest -', 'slz-core' )			=> '',
	esc_html__('Title A to Z', 'slz-core')			=> 'az_order',
	esc_html__('Title Z to A', 'slz-core')			=> 'za_order',
	esc_html__('Post is selected', 'slz-core')		=> 'post__in',
	esc_html__('Random', 'slz-core')				=> 'random_posts',
	esc_html__('Process Low to Hight', 'slz-core')	=> 'process_low_hight',
	esc_html__('Process Hight to Low', 'slz-core')	=> 'process_hight_low',
	esc_html__('Latest start date', 'slz-core')		=> 'start_latest',
	esc_html__('Oldest start date', 'slz-core')		=> 'start_oldest',
	esc_html__('Latest end date', 'slz-core')		=> 'end_latest',
	esc_html__('Oldest end date', 'slz-core')		=> 'end_oldest',
);

// get All Project
$args = array('post_type'     => 'buildplus_project');
$options = array('empty'      => esc_html__( '-All Project-', 'slz-core' ) );
$projects = BuildPlus_Core_Com::get_post_title2id( $args, $options );

// get project categories
$taxonomy = 'buildplus_project_cat';
$params_cat = array('empty'   => esc_html__( '-All Project Categories-', 'slz-core' ) );
$categories = BuildPlus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Description ?', 'slz-core' ),
		'param_name'  	=> 'show_desc',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show description.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Description Type', 'slz-core' ),
		'param_name'  	=> 'desc_type',
		'value'       	=> $desc_type,
		'std'      		=> '',
		'description' 	=> esc_html__( 'Choose type description will be displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Description Length', 'slz-core' ),
		'param_name'      => 'desc_lenght',
		'description'     => esc_html__( 'Enter number for limiting the number of word displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Button Text', 'slz-core' ),
		'param_name'      => 'button_text',
		'description'     => esc_html__( 'Enter value for button displayed. If blank, the button does not show.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),

	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '-1',
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	),

	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Display By', 'slz-core' ),
		'param_name'  => 'method',
		'value'       => $method,
		'description' => esc_html__( 'Choose project category or special projects to display', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Category', 'slz-core' ),
		'param_name'  => 'category',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'callbacks'   => array(
			'after_add' => 'vcChartParamAfterAddCallback'
		),
		'description' => esc_html__( 'Choose project category.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'cat' )
		),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Projects', 'slz-core' ),
		'param_name'      => 'list_post',
		'params'          => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Project', 'slz-core' ),
				'param_name'  => 'project',
				'value'       => $projects,
				'description' => esc_html__( 'Choose special project to show',  'slz-core'  )
			),
			
		),
		'value'           => '',
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'project' )
		),
		'callbacks'       => array(
			'after_add'   => 'vcChartParamAfterAddCallback'
		),
		'description'     => esc_html__( 'Default display All Project if no project is selected and Number project is empty.', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),

	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'color_title',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color Hover', 'slz-core' ),
		'param_name'      => 'color_title_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for block when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'color_description',
		'value'           => '',
		'description'     => esc_html__( 'Choose color description for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Color', 'slz-core' ),
		'param_name'      => 'color_button',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button for block when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color', 'slz-core' ),
		'param_name'      => 'color_button_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color button for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color button for block when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Border Color', 'slz-core' ),
		'param_name'      => 'color_button_border',
		'value'           => '',
		'description'     => esc_html__( 'Choose border color button for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Border Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_border_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose border color button for block when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Projects Carousel', 'slz-core' ),
	'base'        => 'slzcore_project_carousel_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Carousel of projects.', 'slz-core' ),
	'params'      => $params
	)
);