<?php
class Buildplus_Core_Number_Factor {
	public $attributes;
	public $uniq;
	public $html_format;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'number-factor-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'number'             => '',
			'title'              => '',
			'icon_type'          => '',
			'icon_fw'            => '',
			'icon_flat'          => '',
			'number_color'       => '',
			'title_color'        => '',
			'icon_color'         => '',
			'line_color'         => '',
			'extra_class'        => ''
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
	}
	/*-------------------- >> General Functions << --------------------*/
	
	public function setting_html( &$options = array() ){
		$default = array(
			'number_format' => '<h4 data-from="0" data-to="%1$s" data-speed="1500" class="number">0</h4>',
			'title_format'  => '<div class="name">%1$s</div>',
			'icon_format'   => '<i class="icons %1$s"></i>'
		);
		$this->html_format = array_merge( $default, $options);
	}
	public function get_number() {
		$output = '';
		$format = $this->html_format['number_format'];
		if( !empty( $this->attributes['number'] ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $this->attributes['number'] ));
		}
		return $output;
	}
	public function get_title() {
		$output = '';
		$format = $this->html_format['title_format'];
		if( !empty( $this->attributes['title'] ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $this->attributes['title'] ));
		}
		return $output;
	}
	public function get_icon() {
		$output    = $icon = '';
		$icon_type = $this->attributes['icon_type'];
		$format    = $this->html_format['icon_format'];
		if( $icon_type == '02' && !empty( $this->attributes['icon_fw'] ) ){
			$icon = $$this->attributes['icon_fw'];
		}
		elseif( $icon_type != '02' && !empty( $this->attributes['icon_flat'] ) ){
			$icon = $this->attributes['icon_flat'];
		}
		if( !empty( $icon ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $icon ));
		}
		return $output;
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['number_color'] ) ) {
			$custom_css .= '.%1$s .count-number .number{color:%2$s;}' . "\n";
		}
		if( !empty( $this->attributes['title_color'] ) ){
			$custom_css .= '.%1$s .count-number .name{color:%3$s;}' . "\n";
			$custom_css .= '.%1$s .count-number .number:before{background-color:%3$s;}' . "\n";
		}
		if( !empty( $this->attributes['icon_color'] ) ) {
			$custom_css .= '.%1$s .count-number .icons{color:%4$s;}' . "\n";
		}
		if( !empty( $this->attributes['line_color'] ) ) {
			$custom_css .= '.%1$s .count-number .number:before{background-color:%5$s;}' . "\n";
		}
		if ( !empty($custom_css) ) {
			$custom_css = sprintf($custom_css,
				esc_attr(trim($this->uniq)),
				esc_attr($this->attributes['number_color']),
				esc_attr($this->attributes['title_color']),
				esc_attr($this->attributes['icon_color']),
				esc_attr($this->attributes['line_color'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options = array() ) {
		$this->setting_html( $html_options );
		if( $this->attributes['number'] ) {
			printf( $this->html_format['html_format'],
					$this->get_icon(),
					$this->get_number(),
					$this->get_title()
				);
			$this->add_custom_css();
		}
	}
}