<?php
// title
$show_related = Buildplus_Core::get_theme_option('slz-project-show');
$title        = Buildplus_Core::get_theme_option('slz-project-title');
$subtitle     = Buildplus_Core::get_theme_option('slz-project-subtitle');
$background   = Buildplus_Core::get_theme_option('slz-project-bg');
if( !empty( $show_related ) ){ ?>
<div class="related-projects padding-top-100 padding-bottom-100">
	<div class="container">
	<?php
	if( !empty( $title ) ){
		echo do_shortcode( '[slzcore_block_title_sc subtitle="'. esc_attr( $subtitle ) .'" title="'. esc_attr( $title ) .'" mrg_bottom="40px"]' );
	}
	// related post
	$post_id   = get_the_ID();
	$cat_slug  = array();
	$cat_list  = wp_get_post_terms( $post_id, 'buildplus_project_cat' );
	if( !empty( $cat_list ) ){
		foreach( $cat_list as $cat_obj ){
			$cat_slug[]  = $cat_obj->slug;
		}
	}
	if( !empty( $cat_slug ) ){
		$cat_slug = implode( ',', $cat_slug );
		$related_post = '[slzcore_gallery_slide_sc posttype="project" category_slug="'.esc_attr( $cat_slug ).'" slide_arrows="yes"]';
		echo do_shortcode( $related_post );
	}
	?>
	</div>
</div>
<?php
	if( !empty( $background['background-image'] ) ){
		$custom_css = '.related-projects {
						background-image: url("' .esc_url($background['background-image']). '");
						background-color: ' .esc_attr($background['background-color']). ';
						background-repeat: ' .esc_attr($background['background-repeat']). ';
						background-attachment: ' .esc_attr($background['background-attachment']). ';
						background-position:'.esc_attr($background['background-position']).';
						background-size:'.esc_attr($background['background-size']).';}';
		do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
	}
}